/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Pointysaurus
extends EntityLiving {
    public Pointysaurus(World w) {
        super(w);
        this.maxrenderdist = 170;
        this.height = 2.5f;
        this.width = 2.5f;
        this.uniquename = "OreSpawn:Pointysaurus";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(150.0f);
        this.setHealth(150.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 14.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 65;
        this.setExperience(149);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:alo_living";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophypointysaurus.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Pointysaurus) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Pointysaurustexture.png");
        }
        return this.texture;
    }
}

